package com.ejie.ab04b.dao.custom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TareaAperturasDaoImpl;
import com.ejie.ab04b.model.Tarea;
import com.ejie.ab04b.model.TareaAperturas;
import com.ejie.ab04b.model.Tramite;
import com.ejie.ab04b.model.TramiteAperturas;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * TareaAperturasDaoImpl generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class TareaAperturasCustomDaoImpl extends TareaAperturasDaoImpl
		implements TareaAperturasCustomDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TAREA_063 IDTAREA063, t1.MAILBOX_TASK_ID_063 MAILBOXTASKID063, t1.TIPO_TAREA_063 TIPOTAREA063, t1.ESTADO_063 ESTADO063, t1.FECHA_INI_063 FECHAINI063, t1.FECHA_FIN_063 FECHAFIN063, t1.USUARIO_063 USUARIO063, t1.ID_TRAMITE_063 IDTRAMITE063, t1.ID_TRAMITE_090 IDTRAMITE090, t1.TASK_ID_090 TASKID090, t1.DESCRIPCION_ES_090 DESCRIPCIONES090, t1.DESCRIPCION_EU_090 DESCRIPCIONEU090, t1.ES_INICIAL_090 ESINICIAL090, t1.TIPO_090 TIPO090 FROM VTAREAS_APERTURAS t1 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TareaAperturas> rwMap = new RowMapper<TareaAperturas>() {
		public TareaAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TareaAperturas tarea = new TareaAperturas(
					resultSet.getLong("IDTAREA063"),
					resultSet.getString("MAILBOXTASKID063"), null,
					resultSet.getLong("ESTADO063"),
					resultSet.getTimestamp("FECHAINI063"),
					resultSet.getTimestamp("FECHAFIN063"),
					resultSet.getString("USUARIO063"),
					new TramiteAperturas(resultSet.getLong("IDTRAMITE063")));

			tarea.setTipoTarea(new Tarea(resultSet.getLong("TIPOTAREA063"),
					new Tramite(resultSet.getLong("IDTRAMITE090")),
					resultSet.getString("TASKID090"),
					resultSet.getString("DESCRIPCIONES090"),
					resultSet.getString("DESCRIPCIONEU090"),
					resultSet.getBoolean("ESINICIAL090"),
					resultSet.getString("TIPO090")));

			return tarea;
		}
	};

	/**
	 * Finds a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	@Transactional(readOnly = true)
	public TareaAperturas vfind(TareaAperturas tareaAperturas) {
		StringBuilder query = new StringBuilder(
				TareaAperturasCustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_063 = ? ");

		List<TareaAperturas> tareaAperturasList = this.getJdbcTemplate().query(
				query.toString(), this.rwMap, tareaAperturas.getIdTarea063());
		return (TareaAperturas) DataAccessUtils
				.uniqueResult(tareaAperturasList);
	}

	/**
	 * Finds a list of rows in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TareaAperturas>
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TareaAperturas> vfindAll(TareaAperturas tareaAperturas,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				TareaAperturasCustomDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tareaAperturas);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" ORDER BY t1.FECHA_INI_063 DESC");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TareaAperturas>) this.getJdbcTemplate()
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TareaAperturas entity
	 * 
	 *  tareaAperturas
	 *            TareaAperturas Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TareaAperturas tareaAperturas) {

		StringBuilder where = new StringBuilder(
				TareaAperturasCustomDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tareaAperturas != null && tareaAperturas.getIdTarea063() != null) {
			where.append(" AND t1.ID_TAREA_063 = ?");
			params.add(tareaAperturas.getIdTarea063());
		}
		if (tareaAperturas != null
				&& tareaAperturas.getTramiteAperturas() != null
				&& tareaAperturas.getTramiteAperturas()
						.getIdTramite062() != null) {
			where.append(" AND t1.ID_TRAMITE_063 = ?");
			params.add(tareaAperturas.getTramiteAperturas().getIdTramite062());
		}
		if (tareaAperturas != null
				&& tareaAperturas.getMailboxTaskId063() != null) {
			where.append(" AND t1.MAILBOX_TASK_ID_063 = ?");
			params.add(tareaAperturas.getMailboxTaskId063());
		}
		if (tareaAperturas != null && tareaAperturas.getEstado063() != null) {
			where.append(" AND t1.ESTADO_063 = ?");
			params.add(tareaAperturas.getEstado063());
		}
		if (tareaAperturas != null && tareaAperturas.getFechaIni063() != null) {
			where.append(" AND t1.FECHA_INI_063 = ?");
			params.add(tareaAperturas.getFechaIni063());
		}
		if (tareaAperturas != null && tareaAperturas.getFechaFin063() != null) {
			where.append(" AND t1.FECHA_FIN_063 = ?");
			params.add(tareaAperturas.getFechaFin063());
		}
		if (tareaAperturas != null && tareaAperturas.getUsuario063() != null) {
			where.append(" AND t1.USUARIO_063 = ?");
			params.add(tareaAperturas.getUsuario063());
		}

		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getIdTarea090() != null) {
			where.append(" AND t1.TIPO_TAREA_063 = ?");
			params.add(tareaAperturas.getTipoTarea().getIdTarea090());
		}
		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getTramite() != null
				&& tareaAperturas.getTipoTarea().getTramite()
						.getIdTramite089() != null) {
			where.append(" AND t1.ID_TRAMITE_090 = ?");
			params.add(tareaAperturas.getTipoTarea().getTramite()
					.getIdTramite089());
		}
		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getTaskId090() != null) {
			where.append(" AND t1.TASK_ID_090 = ?");
			params.add(tareaAperturas.getTipoTarea().getTaskId090());
		}
		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea()
						.getDescripcionEs090() != null) {
			where.append(" AND t1.DESCRIPCION_ES_090 = ?");
			params.add(tareaAperturas.getTipoTarea().getDescripcionEs090());
		}
		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea()
						.getDescripcionEu090() != null) {
			where.append(" AND t1.DESCRIPCION_EU_090 = ?");
			params.add(tareaAperturas.getTipoTarea().getDescripcionEu090());
		}
		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getEsInicial090() != null) {
			where.append(" AND t1.ES_INICIAL_090 = ?");
			params.add(tareaAperturas.getTipoTarea().getEsInicial090());
		}
		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getEsInicial090() != null) {
			where.append(" AND t1.TIPO_090 = ?");
			params.add(tareaAperturas.getTipoTarea().getEsInicial090());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

}
